<?php
/* Copyright (C) 2009-2019	Laurent Destailleur		<eldy@users.sourceforge.org>
 * Copyright (C) 2011-2013  Juanjo Menent			<jmenent@2byte.es>
 * Copyright (C) 2024		MDW						<mdeweerd@users.noreply.github.com>
 * Copyright (C) 2024-2025  Frédéric France         <frederic.france@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

/**
 *	\file       htdocs/admin/geoipmaxmind.php
 *	\ingroup    geoipmaxmind
 *	\brief      Setup page for geoipmaxmind module
 */

// Load Dolibarr environment
require '../main.inc.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/admin.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/dolgeoip.class.php';

/**
 * @var Conf $conf
 * @var DoliDB $db
 * @var HookManager $hookmanager
 * @var Translate $langs
 * @var User $user
 */

// Security check
if (!$user->admin) {
	accessforbidden();
}

// Load translation files required by the page
$langs->loadLangs(array("admin", "errors"));

$action = GETPOST('action', 'aZ09');


/*
 * Actions
 */

if ($action == 'set') {
	$error = 0;

	$gimcdf = GETPOST("GEOIPMAXMIND_COUNTRY_DATAFILE");

	if (!$error && $gimcdf && !preg_match('/\.(dat|mmdb)$/', $gimcdf)) {
		setEventMessages($langs->trans("ErrorFileMustHaveFormat", '.dat|.mmdb'), null, 'errors');
		$error++;
	}

	$res1 = dolibarr_set_const($db, "GEOIP_VERSION", GETPOST('geoipversion', 'aZ09'), 'chaine', 0, '', $conf->entity);
	if (!($res1 > 0)) {
		$error++;
	}

	$res2 = dolibarr_set_const($db, "GEOIPMAXMIND_COUNTRY_DATAFILE", $gimcdf, 'chaine', 0, '', $conf->entity);
	if (!($res2 > 0)) {
		$error++;
	}

	if (!$error) {
		setEventMessages($langs->trans("SetupSaved"), null, 'mesgs');
	} else {
		//setEventMessages($langs->trans("Error"), null, 'errors');
	}
}

if (!isset($conf->global->GEOIP_VERSION)) {
	$conf->global->GEOIP_VERSION = '2';
}


/*
 * View
 */

$form = new Form($db);

llxHeader('', '', '', '', 0, 0, '', '', '', 'mod-admin page-geoipmaxmind');

$linkback = '<a href="'.DOL_URL_ROOT.'/admin/modules.php?restore_lastsearch_values=1">'.img_picto($langs->trans("BackToModuleList"), 'back', 'class="pictofixedwidth"').'<span class="hideonsmartphone">'.$langs->trans("BackToModuleList").'</span></a>';

print load_fiche_titre($langs->trans("GeoIPMaxmindSetup"), $linkback, 'title_setup');
print '<br>';

$version = '';
$geoip = '';
if (getDolGlobalString('GEOIPMAXMIND_COUNTRY_DATAFILE')) {
	$geoip = new DolGeoIP('country', $conf->global->GEOIPMAXMIND_COUNTRY_DATAFILE);
}

// Mode
print '<form action="'.$_SERVER["PHP_SELF"].'" method="post">';
print '<input type="hidden" name="token" value="'.newToken().'">';
print '<input type="hidden" name="action" value="set">';

print '<table class="noborder centpercent">';
print '<tr class="liste_titre">';
print '<td>'.$langs->trans("Parameter").'</td><td></td>';
print '<td class="right"><input type="submit" class="button button-edit" value="'.$langs->trans("Modify").'"></td>';
print "</tr>\n";

// Lib version
print '<tr class="oddeven"><td>'.$langs->trans("GeoIPLibVersion").'</td>';
print '<td>';
$arrayofvalues = array('php' => 'Native PHP functions', '1' => 'Embedded GeoIP v1', '2' => 'Embedded GeoIP v2');
print $form->selectarray('geoipversion', $arrayofvalues, getDolGlobalString('GEOIP_VERSION', '2'));
if (getDolGlobalString('GEOIP_VERSION') == 'php') {
	if ($geoip) {
		$version = $geoip->getVersion();
	}
	if ($version) {
		print '<br>'.$langs->trans("Version").': '.$version;
	}
}
print '</td>';
print '<td>';
print '</td></tr>';

$gimcdf = getDolGlobalString('GEOIPMAXMIND_COUNTRY_DATAFILE');

// Path to database file
print '<tr class="oddeven"><td>'.$langs->trans("PathToGeoIPMaxmindCountryDataFile").'</td>';
print '<td>';
if (getDolGlobalString('GEOIP_VERSION') == 'php') {
	print 'Using geoip PHP internal functions. Value must be '.geoip_db_filename(GEOIP_COUNTRY_EDITION).' or '.geoip_db_filename(GEOIP_CITY_EDITION_REV1).' or /pathtodatafile/GeoLite2-Country.mmdb<br>';
}
print '<input type="text" class="minwidth200" name="GEOIPMAXMIND_COUNTRY_DATAFILE" value="'.dol_escape_htmltag(getDolGlobalString('GEOIPMAXMIND_COUNTRY_DATAFILE')).'">';
if (!file_exists(str_replace('DOL_DATA_ROOT', DOL_DATA_ROOT, $gimcdf))) {
	print '<div class="error">'.$langs->trans("ErrorFileNotFound", $gimcdf).'</div>';
}
print '</td><td>';
print '<span class="opacitymedium">';
print $langs->trans("Example").'<br>';
print '/usr/local/share/GeoIP/GeoIP.dat<br>
/usr/share/GeoIP/GeoIP.dat<br>
/usr/share/GeoIP/GeoLite2-Country.mmdb';
print '</span>';
print '</td></tr>';

print '</table>';

print "</form>\n";

print '<br>';

print $langs->trans("NoteOnPathLocation").'<br>';

$url1 = 'http://www.maxmind.com/en/city?rId=awstats';
$textoshow = $langs->trans("YouCanDownloadFreeDatFileTo", '{s1}');
$textoshow = str_replace('{s1}', '<a href="'.$url1.'" target="_blank" rel="noopener noreferrer external">'.$url1.'</a>', $textoshow);
print $textoshow;

print '<br>';

$url2 = 'http://www.maxmind.com/en/city?rId=awstats';
$textoshow = $langs->trans("YouCanDownloadAdvancedDatFileTo", '{s1}');
$textoshow = str_replace('{s1}', '<a href="'.$url2.'" target="_blank" rel="noopener noreferrer external">'.$url2.'</a>', $textoshow);
print $textoshow;

if ($geoip) {
	print '<form action="'.$_SERVER["PHP_SELF"].'" method="post">';
	print '<input type="hidden" name="token" value="'.newToken().'">';

	$ip = '24.24.24.24';

	print '<br><br>';
	print '<br><span class="opacitymedium">'.$langs->trans("TestGeoIPResult", $ip).':</span>';

	print '<br>'.$ip.' -> ';
	$result = dol_print_ip($ip, 1);
	if ($result) {
		print $result;
	} else {
		print $langs->trans("Error");
	}

	$ip = '2a01:e0a:7e:4a60:429a:23ff:f7b8:dc8a'; // should be France
	print '<br>'.$ip.' -> ';
	$result = dol_print_ip($ip, 1);
	if ($result) {
		print $result;
	} else {
		print $langs->trans("Error");
	}


	/* We disable this test because dol_print_ip need an ip as input
	$ip='www.google.com';
	print '<br>'.$ip.' -> ';
	$result=dol_print_ip($ip,1);
	if ($result) print $result;
	else print $langs->trans("Error");
	*/
	//var_dump($_SERVER);
	$ip = getUserRemoteIP();
	//$ip='91.161.249.43';
	$isip = is_ip($ip);
	if ($isip == 1) {
		print '<br>'.$ip.' -> ';
		$result = dol_print_ip($ip, 1);
		if ($result) {
			print $result;
		} else {
			print $langs->trans("Error");
		}
	} else {
		print '<br>'.$ip.' -> ';
		$result = dol_print_ip($ip, 1);
		if ($result) {
			print $result;
		} else {
			print $langs->trans("NotAPublicIp");
		}
	}

	$ip = GETPOST("iptotest");
	print '<br><input type="text class="width100" name="iptotest" id="iptotest" placeholder="'.dol_escape_htmltag($langs->trans("EnterAnIP")).'" value="'.$ip.'">';
	print '<input type="submit" class="width40 button small smallpaddingimp" value=" -> ">';
	if ($ip) {
		$result = dol_print_ip($ip, 1);
		if ($result) {
			print $result;
		} else {
			print $langs->trans("Error");
		}
	}

	print '</form>';

	$geoip->close();
}

// End of page
llxFooter();
$db->close();
